/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.screen.LogsScreen;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.client.screen.text_editor.SFMMultiLineTextRenderWidget;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditorUtils;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

class LogsScreenMultiLineEditBox
extends MultiLineEditBox {
    private final LogsScreen logsScreen;
    public SFMMultiLineTextRenderWidget textRenderWidget;
    public List<MutableComponent> styledTextContentLines = Collections.emptyList();
    private boolean scrollingEnabled = true;
    private boolean scrollbarDragActive;

    public LogsScreenMultiLineEditBox(LogsScreen logsScreen, Font pFont, int pX, int pY, int pWidth, int pHeight, Component pPlaceholder, Component pMessage) {
        super(pFont, pX, pY, pWidth, pHeight, pPlaceholder, pMessage);
        Rect2i textRenderWidgetArea = new Rect2i(SFMWidgetUtils.getX((AbstractWidget)this) + this.innerPadding(), SFMWidgetUtils.getY((AbstractWidget)this) + this.innerPadding(), this.width - this.totalInnerPadding(), this.height - this.totalInnerPadding());
        this.textRenderWidget = new SFMMultiLineTextRenderWidget(pFont, textRenderWidgetArea);
        this.textRenderWidget.setStyledTextContentLines(this.styledTextContentLines);
        this.textRenderWidget.setTextContent(this.getValue());
        this.logsScreen = logsScreen;
    }

    public void scrollToBottom() {
        this.setScrollAmount(this.getMaxScrollAmount());
    }

    public int getScrollBarHeight() {
        int rtn = super.getScrollBarHeight();
        if (rtn == this.height) {
            return rtn - 1;
        }
        return rtn;
    }

    @MCVersionDependentBehaviour
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        try {
            boolean clickedScrollbar;
            if (pButton == 0) {
                this.scrollbarDragActive = false;
            }
            if (pButton == 0 && this.visible && this.withinContentAreaPoint(pMouseX, pMouseY)) {
                if (this.styledTextContentLines.isEmpty()) {
                    return false;
                }
                this.setFocused(true);
                boolean shiftDown = Screen.hasShiftDown();
                this.seekCursorFromPoint(pMouseX, pMouseY);
                if (!shiftDown) {
                    this.textField.selectCursor = this.textField.cursor;
                }
                this.textField.setSelecting(true);
                return true;
            }
            boolean bl = clickedScrollbar = pButton == 0 && this.visible && this.scrollbarVisible() && pMouseX >= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.width) && pMouseX <= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.width + 8) && pMouseY >= (double)SFMWidgetUtils.getY((AbstractWidget)this) && pMouseY < (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.height);
            if (clickedScrollbar) {
                this.scrollbarDragActive = true;
            }
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        catch (Exception e) {
            SFM.LOGGER.error("Error in mouseClicked handler", (Throwable)e);
            return false;
        }
    }

    public int getInnerHeight() {
        Objects.requireNonNull(this.font);
        return 9 * (this.styledTextContentLines.size() + 2);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (button == 0) {
            this.textField.setSelecting(false);
            this.scrollbarDragActive = false;
        }
        return super.mouseReleased(mx, my, button);
    }

    public boolean mouseDragged(double mx, double my, int button, double dx, double dy) {
        if (this.scrollbarDragActive && super.mouseDragged(mx, my, button, dx, dy)) {
            return true;
        }
        try {
            if (button == 0 && this.visible && this.withinContentAreaPoint(mx, my)) {
                if (this.styledTextContentLines.isEmpty()) {
                    return false;
                }
                this.textField.setSelecting(true);
                this.seekCursorFromPoint(mx, my);
                return true;
            }
        }
        catch (Exception e) {
            SFM.LOGGER.error("Error in mouseDragged handler", (Throwable)e);
            return false;
        }
        return false;
    }

    protected void setScrollAmount(double pScrollAmount) {
        if (!this.scrollingEnabled) {
            return;
        }
        super.setScrollAmount(pScrollAmount);
    }

    private void seekCursorFromPoint(double mx, double my) {
        int lineCount = this.styledTextContentLines.size();
        double innerX = mx - (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.innerPadding() + SFMTextEditorUtils.getLineNumberWidth(this.font, lineCount));
        double innerY = my - (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.innerPadding()) + this.scrollAmount();
        int cursorPosition = this.textRenderWidget.pointToCharacterIndex(innerX, innerY);
        this.scrollingEnabled = false;
        this.textField.seekCursor(Whence.ABSOLUTE, cursorPosition);
        this.scrollingEnabled = true;
    }

    protected int getMaxScrollAmount() {
        return Math.max(1, super.getMaxScrollAmount());
    }

    protected void renderContents(GuiGraphics pGuiGraphics, int mx, int my, float partialTicks) {
        if (this.logsScreen.shouldRebuildText()) {
            this.logsScreen.rebuildText();
        }
        this.textRenderWidget.setCursorIndex(this.textField.cursor());
        this.textRenderWidget.setFocused(this.isFocused());
        this.textRenderWidget.setScrollAmount(this.scrollAmount());
        this.textRenderWidget.setSelected(this.textField.getSelected());
        this.textRenderWidget.render(pGuiGraphics, mx, my, partialTicks);
    }
}

